// Standalone entry point for dashboard.html
// Uses global React and ReactDOM from CDN

import { InputConfigProvider } from './store';
import { InputConfigButton } from './components/InputConfigButton';
import { InputConfigDrawer } from './components/InputConfigDrawer';

function InputConfigurationApp() {
  // @ts-ignore - React is loaded from CDN
  const React = window.React;
  
  return React.createElement(InputConfigProvider, null,
    React.createElement(InputConfigButton),
    React.createElement(InputConfigDrawer)
  );
}

// Export mount function for global use
if (typeof window !== 'undefined') {
  (window as any).mountInputConfiguration = function(containerId: string) {
    const container = document.getElementById(containerId);
    if (!container) {
      console.error(`Container with id "${containerId}" not found`);
      return;
    }

    // Use global React and ReactDOM from CDN
    const ReactGlobal = (window as any).React;
    const ReactDOMGlobal = (window as any).ReactDOM;

    if (!ReactGlobal || !ReactDOMGlobal) {
      console.error('React or ReactDOM not loaded. Make sure CDN scripts are included.');
      return;
    }

    // Create root and render
    const root = ReactDOMGlobal.createRoot(container);
    root.render(ReactGlobal.createElement(InputConfigurationApp));

    // Store cleanup function
    (container as any).__unmount = () => {
      root.unmount();
    };
  };
}

export default InputConfigurationApp;
