import { createRoot } from 'react-dom/client';
import { InputConfigProvider } from './store';
import { InputConfigButton } from './components/InputConfigButton';
import { InputConfigDrawer } from './components/InputConfigDrawer';

function InputConfigurationApp() {
  return (
    <InputConfigProvider>
      <InputConfigButton />
      <InputConfigDrawer />
    </InputConfigProvider>
  );
}

export function mountInputConfiguration(containerId: string) {
  const container = document.getElementById(containerId);
  if (!container) {
    console.error(`Container with id "${containerId}" not found`);
    return null;
  }

  const root = createRoot(container);
  root.render(<InputConfigurationApp />);

  return () => {
    root.unmount();
  };
}

// Expose globally for dashboard.html
if (typeof window !== 'undefined') {
  (window as any).mountInputConfiguration = mountInputConfiguration;
  
  // Auto-mount if container exists (for development/testing)
  const container = document.getElementById('carbon-center-config');
  if (container) {
    mountInputConfiguration('carbon-center-config');
  }
}

export default InputConfigurationApp;

