import { Settings } from 'lucide-react';
import { useInputConfig } from '../store';

export function InputConfigButton() {
  const { openDrawer } = useInputConfig();

  return (
    <button
      onClick={openDrawer}
      className="inline-flex items-center gap-2 px-4 py-2 bg-gradient-to-r from-primary to-accent text-white rounded-lg hover:shadow-md transition-all duration-300 font-medium text-sm"
    >
      <Settings className="w-4 h-4" />
      <span>Input Configuration</span>
    </button>
  );
}

