import { motion } from 'framer-motion';
import { TrendingDown, CheckCircle2, Zap } from 'lucide-react';

const stats = [
    {
        icon: TrendingDown,
        value: "40%",
        label: "Reduction in Operational Costs",
        color: "text-green-400"
    },
    {
        icon: CheckCircle2,
        value: "99.9%",
        label: "Compliance Accuracy",
        color: "text-primary"
    },
    {
        icon: Zap,
        value: "< 5min",
        label: "Report Generation Time",
        color: "text-yellow-400"
    }
];

export default function ValueDelivered() {
    return (
        <section className="py-20 bg-white/5 border-y border-white/5">
            <div className="container mx-auto px-6">
                <div className="grid md:grid-cols-3 gap-12">
                    {stats.map((stat, index) => (
                        <motion.div
                            key={index}
                            initial={{ opacity: 0, scale: 0.9 }}
                            whileInView={{ opacity: 1, scale: 1 }}
                            viewport={{ once: true }}
                            transition={{ delay: index * 0.2 }}
                            className="text-center group"
                        >
                            <div className="flex justify-center mb-6">
                                <div className={`p-4 rounded-full bg-white/5 ${stat.color} group-hover:scale-110 transition-transform duration-300`}>
                                    <stat.icon className="w-8 h-8" />
                                </div>
                            </div>
                            <h3 className={`text-5xl font-bold mb-2 ${stat.color}`}>{stat.value}</h3>
                            <p className="text-gray-400 font-medium">{stat.label}</p>
                        </motion.div>
                    ))}
                </div>
            </div>
        </section>
    );
}
