import { motion } from 'framer-motion';
import { Layers, FileCheck, Wifi, ShieldCheck } from 'lucide-react';

const features = [
    {
        icon: Layers,
        title: "All Compliance in One Platform",
        description: "Replace 10 separate systems with one unified environment covering sustainability, carbon, EPD, ISO, energy, LEED, ESG, and safety.",
        color: "text-primary"
    },
    {
        icon: FileCheck,
        title: "AI-Generated Official Reports",
        description: "Automated generation of GHG, ISO, EPD, ESG, NCEC, LEED, HCIS, Safety, and Civil Defense reports.",
        color: "text-accent"
    },
    {
        icon: Wifi,
        title: "Direct IoT Integration",
        description: "Live monitoring, automatic readings, real-time alerts, and AI-driven risk & emission forecasting.",
        color: "text-blue-400"
    },
    {
        icon: ShieldCheck,
        title: "100% Saudi Regulations Aligned",
        description: "Fully compliant with NCEC, HCIS, SASO, Ministry of Energy, Civil Defense, and Balady regulations.",
        color: "text-green-400"
    }
];

export default function KeyFeatures() {
    return (
        <section id="solutions" className="py-24 relative overflow-hidden">
            <div className="container mx-auto px-6">
                <motion.div
                    initial={{ opacity: 0, y: 20 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    viewport={{ once: true }}
                    className="text-center mb-16"
                >
                    <h2 className="text-4xl font-bold mb-4">Comprehensive <span className="text-gradient">Capabilities</span></h2>
                    <p className="text-gray-400 max-w-2xl mx-auto">
                        Everything you need to manage compliance and sustainability in one powerful platform.
                    </p>
                </motion.div>

                <div className="grid md:grid-cols-2 gap-8">
                    {features.map((feature, index) => (
                        <motion.div
                            key={index}
                            initial={{ opacity: 0, y: 30 }}
                            whileInView={{ opacity: 1, y: 0 }}
                            viewport={{ once: true }}
                            transition={{ delay: index * 0.1 }}
                            whileHover={{ y: -5 }}
                            className="group relative"
                        >
                            <div className="absolute inset-0 bg-gradient-to-br from-primary/10 to-transparent rounded-3xl blur-xl opacity-0 group-hover:opacity-100 transition-opacity duration-500" />

                            <div className="relative h-full bg-white/5 backdrop-blur-lg border border-white/10 rounded-3xl p-8 hover:border-primary/50 transition-colors duration-300 overflow-hidden">
                                {/* Neon Edge Glow */}
                                <div className="absolute inset-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500 pointer-events-none">
                                    <div className="absolute top-0 left-0 w-full h-[1px] bg-gradient-to-r from-transparent via-primary to-transparent" />
                                    <div className="absolute bottom-0 left-0 w-full h-[1px] bg-gradient-to-r from-transparent via-primary to-transparent" />
                                </div>

                                {/* Floating Orb/Icon */}
                                <div className="mb-6 relative">
                                    <div className={`w-14 h-14 rounded-2xl bg-white/5 flex items-center justify-center ${feature.color} group-hover:scale-110 transition-transform duration-300`}>
                                        <feature.icon className="w-8 h-8" />
                                    </div>
                                    <div className={`absolute -inset-2 ${feature.color} opacity-20 blur-lg rounded-full group-hover:opacity-40 transition-opacity`} />
                                </div>

                                <h3 className="text-2xl font-bold mb-4 group-hover:text-primary transition-colors">{feature.title}</h3>
                                <p className="text-gray-400 leading-relaxed">
                                    {feature.description}
                                </p>
                            </div>
                        </motion.div>
                    ))}
                </div>
            </div>
        </section>
    );
}
