import { motion } from 'framer-motion';

export default function AIDigitalTwin() {
    return (
        <section className="py-24 relative overflow-hidden bg-dark">
            {/* Background Grid */}
            <div className="absolute inset-0 bg-[linear-gradient(rgba(29,167,161,0.05)_1px,transparent_1px),linear-gradient(90deg,rgba(29,167,161,0.05)_1px,transparent_1px)] bg-[size:40px_40px] [mask-image:radial-gradient(ellipse_at_center,black_40%,transparent_70%)]" />

            <div className="container mx-auto px-6 grid lg:grid-cols-2 gap-16 items-center relative z-10">
                {/* Digital Twin Visualization */}
                <motion.div
    initial={{ opacity: 0, scale: 0.9 }}
    whileInView={{ opacity: 1, scale: 1 }}
    viewport={{ once: true }}
    transition={{ duration: 0.6, ease: "easeOut" }}
    className="relative flex justify-center"
>
    <div className="relative max-w-lg w-full">
        {/* Glow خلف الصورة */}
        <div className="absolute inset-0 bg-gradient-to-br from-primary/20 to-secondary/20 blur-3xl rounded-2xl" />

        <img
            src="/d_dig_twin.PNG"
            alt="AI Digital Twin Visualization"
            className="relative z-10 w-full rounded-2xl shadow-2xl shadow-primary/20"
        />
    </div>
</motion.div>

                {/* Content */}
                <div>
                    <motion.div
                        initial={{ opacity: 0, x: 50 }}
                        whileInView={{ opacity: 1, x: 0 }}
                        viewport={{ once: true }}
                    >
                        <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary/10 border border-primary/20 mb-6">
                            <span className="w-2 h-2 rounded-full bg-primary animate-pulse" />
                            <span className="text-sm text-primary font-medium">AI-Powered Intelligence</span>
                        </div>

                        <h2 className="text-4xl lg:text-5xl font-bold mb-6 leading-tight">
                            Powered by AI, IoT, and <span className="text-gradient">Digital Twin</span> Technology
                        </h2>

                        <p className="text-gray-400 text-lg mb-8 leading-relaxed">
                            Create a living digital replica of your facility. Our AI engine processes millions of data points in real-time to predict emissions, optimize energy usage, and ensure 24/7 compliance without human intervention.
                        </p>

                        <ul className="space-y-4">
                            {[
                                "Real-time environmental monitoring & alerts",
                                "Predictive maintenance & emission forecasting",
                                "Automated regulatory reporting generation",
                                "Seamless integration with existing IoT sensors"
                            ].map((item, index) => (
                                <li key={index} className="flex items-center gap-3 text-gray-300">
                                    <div className="w-6 h-6 rounded-full bg-primary/20 flex items-center justify-center flex-shrink-0">
                                        <div className="w-2 h-2 rounded-full bg-primary" />
                                    </div>
                                    {item}
                                </li>
                            ))}
                        </ul>
                    </motion.div>
                </div>
            </div>
        </section>
    );
}
