# Input Configuration Build Instructions

## Current Status

The Input Configuration button is now visible in the Carbon Center dashboard with a placeholder implementation. The full React component requires building.

## Quick Start (Placeholder Button)

The placeholder button is already working! When you open the Carbon Center dashboard, you'll see the "Input Configuration" button in the top-right corner. It currently shows an alert when clicked.

## Building the Full React Component

To build the full React component with all functionality:

### Option 1: Use Vite Dev Server (Recommended for Development)

1. Start the Vite dev server:
```bash
npm run dev
```

2. The React component will be available at `http://localhost:5173`

3. Update `dashboard.html` to load from the dev server (temporary):
   - Add a script tag pointing to the dev server bundle

### Option 2: Build as Standalone Bundle (For Production)

The build configuration is set up but needs some adjustments. The current issue is with module resolution in the standalone build.

**Temporary Workaround:**

For now, the placeholder button works immediately. To get the full React component working:

1. **Use the main Vite build** and serve the dashboard through Vite:
   ```bash
   npm run dev
   ```
   Then access dashboard.html through the Vite server.

2. **Or integrate the Input Configuration into the main React app** instead of embedding it in dashboard.html.

## Files Created

- `src/pages/input-configuration/` - All React components
- `vite.input-config.config.ts` - Build configuration
- `dashboard.html` - Updated with mount point and placeholder

## Next Steps

1. The placeholder button is working - you can see it in the Carbon Center dashboard
2. For full functionality, either:
   - Use Vite dev server to serve everything
   - Fix the standalone build configuration (module resolution issues)
   - Integrate into the main React app route

## Current Implementation

- ✅ Placeholder button visible and working
- ✅ React component code complete
- ✅ Build configuration created
- ⚠️ Standalone build needs module resolution fix
- ✅ Dashboard integration ready


